#  Color Concepts
Color theory has an enormous impact on decoding/rendering/encoding video frames.  It is important to explain and provide clarity on the various color-related concepts that impact our video pipeline
    
## Color Primaries 
    Color primaries are the fundamental colors used in a color model to create all other colors. They serve as the basis for mixing and reproducing a full range of colors.  Primaries are typically quoted in representative colors (ex. Red/Green/Blue (RGB), Cyan/Magenta/Yellow(CMY)).  All colors are created by specifying certain values for the representative color.
    
    Common Primaries:
    - RGB (Red, Green, Blue)
        - Used in light-based color systems like screens (TVs, monitors, projectors).
        - When combined at full intensity, they produce white light.
        - Example: Digital displays use RGB subpixels to create color image
    - CMY/CMYK (Cyan, Magenta, Yellow, Black(K))
        - Used in printing, where colors are created by absorbing (subtracting) light.
        - In practice, black (K) is added to improve depth and contrast, forming CMYK.
        - Example: Printers use CMYK inks to mix colors.
    - YUV/YCbCr/YIQ
        - Luminance-Chrominance
        - Used in video and television broadcasting, as well as image compression (JPEG, MPEG).
        - Y (Luminance) represents brightness, while U, V (or Cb, Cr) define color information.
        - Helps in black-and-white compatibility and efficient color transmission.
    - RYB (Red, Yellow, Blue)
        - Perceptual Primaries
        - Traditional primary colors used in art and painting.
        - Based on classical color theory rather than scientific color mixing
    - HSL/HSV (Hue, Saturation, Lightness / Hue, Saturation, Value)
        - Perceptual
        - Define color based on human perception.
        - Useful in software for adjusting colors more intuitively.
    - LMS (Long, Medium, Short Wavelengths)
        - Human vision model
        - Based on the three types of cones in the human eye
            - L (Long-wavelength, Red-sensitive)
            - M (Medium-wavelength, Green-sensitive)
            - S (Short-wavelength, Blue-sensitive)
        - More biologically accurate than RGB in describing how humans perceive color.
    - XYZ (CIE 1931)
        - Standardized Color Space
        - Defined by the International Commission on Illumination (CIE).
        - Based on human visual perception rather than device-dependent primaries.
        - Forms the basis of color science and defines all possible perceivable colors.
        
## Luminance 
    Luminance refers to the perceived brightness of a color, independent of its hue (color) and saturation (intensity). It is a measure of how much light is emitted, reflected, or transmitted from a surface in a given direction.  It's a measurement of how bright a surface appears (light emitted or reflected from a surface).
    
    - Relationship with Brightness:
        - Luminance is an objective physical measurement while brightness is subjective and depends on human perception
    - Relationship with Color Primaries:
        - Luminance is derived from a weighted sum of the color primaries (eg. red, green, and blue components)
        - In RGB spaces, green contributes the most to luminance since human vision is most sensitive to green light.
    - Relationship with Video/Display:
        - Used in HDR (High Dynamic Range) content for better contrast and brightness.
        - Defines screen brightness and HDR capabilities.
        - Determines contrast, grayscale conversion, and tone mapping.
        - In black-and-white images, luminance values determine how colors are converted to grayscale.
    
## Color Gamut
    Color gamut is the complete range of colors that can be reproduced by a particular device, system, or medium (TV,printer, camera, human-eye, etc.).  These are typically represented as a geometrical shape, usually a triangle, with the verticies of the shape being represented by an x/y coordinate pair for each color primary; in an RGB gamut Red will have an x/y, Green an x/y, Blue an x/y.  All colors in the gamut will fall in the area bound by these verticies.  Think of primaries as the corners of a triangle and the gamut as the area inside the triangle. The primaries set the limits, but the gamut is the whole space you can fill with color.
    
     A gamut is just the range of colors that can be reproduced, without dictating how they're encoded or managed.
     
     Common Gamuts:
     - sRGB
     - sRGB
     - Adobe RGB
     - DCI-P3
     - Rec. 2020
     - ProPhoto RGB
## Gamma 
    Gamma refers to the nonlinear relationship between the input signal (e.g., pixel values) and the displayed brightness (luminance). It is a correction factor applied to compensate for how human vision perceives brightness.  Human perception is non linear and are more sensitive to dark shades than bright ones.  
    ### Gamma Levels
        - Linear (1.0)
            - No correction/direct mapping
            - Used in HDR workflows and scientific computing
                - Think RAW images
        - Low (eg. 1.8)
            - Images appear brighter
            - Useful in printing workflows 
        - High (eg 2.6)
            - Images appear darker.
            - Ideal for cinema
        - sRGB (appx 2.2)
            - Standard because it closely matches human vision
            
        Gamma values (e.g., 1.8, 2.2, 2.4, 2.6) define the power-law relationship between an input signal (pixel value) and the output luminance (brightness) on a display. The gamma value determines how brightness is distributed across an image, compensating for human vision’s nonlinear sensitivity to light.
        
        Gamma correction follows the equation:
        Output Luminance=(Input Signal)^γ
        where γ (gamma) is the exponent that controls the contrast and brightness curve.
        
        Gamma correction is necessary to ensure images look consistent across different devices and is essential for maintaining  color consistency 
    ### Gamma Curve
        Ensures digital images match how humans perceive light naturally 
    ### Gamma Encoding
        Digital images are stored in a gamma-encoded form (nonlinear) to preserve details in shadows and highlights.  Without gamma correction, images would appear either too dark or too washed out
    ### Gamma and Display
        Screens and projectors apply gamma decoding to convert the nonlinear image data back into a linear brightness output.  Different devices use different gamma values.
        
## Transfer Functions
    Transfer functions, like gamma, is a mathematical curve to map/augment brightness levels.  Unlike simple gamma curves, transfer functions contain additional adjustments for precise color and tone reproduction and are used extensivley in video workflows 
    
    Common Transfer Functions used in video workflows:
    - Rec. 709 (BT.1886 EOTF0)
    - SMPTE 240M 1995
    - EBU 3213
    - SMPTE C
    - sRGB
    - Rec. 2020
    - PQ
    - 2100 HLG
    
## White Point
    A measure of color temperature that defines what is considered "neutral white" in a particular color space, display system, or image processing workflow. It determines how colors, especially grays and whites, appear under different lighting conditions.  White Point specification can ensure color consistency across different devices and afffects perceived warmth/coolness of an image and plays a crucial role in color management systems (CMS).  Incorrect white point settings can cause color shifts (e.g., making an image appear too warm or too cool).
    
    White Point is typically utilizes Kelvins (K) as the standard unit of measurement  
    
    White Point will also contain X/Y coordinates which refer to the chromaticity coordinates of a white reference in a chromaticity diagram.  These coordinates define the precise color of white used in different color standards and define what is considered to be neutral white in a color system
    
    Common White Points Utilized in Video Workflows:
    - D50
        - 5000K
        - (0.34567, 0.35850) XY
        - Standard for printing, graphic design
        - used in printing and prepress workflows to simulate warm lighting conditions.
    - D55
        - 5500 K
        - (0.33242, 0.34743) XY
        - Often used in photography (daylight balance)
    - D65
        - 6500 K
        - (0.31271, 0.32902) XY
        - Standard for sRGB, Rec. 709 (HDTV), Adobe RGB
        - the most common standard in digital imaging, as it closely matches average daylight.
    - D75
        - 7500 K
        - (0.29902, 0.31485) XY
        - Cooler daylight, less commonly used
    - 9300 K
        - (0.28315, 0.29711) XY
        - Older CRT monitors, some office lighting
        
## Color Matrix
    A color matrix is a mathematical transformation used to convert colors between different color spaces (e.g., RGB to YUV, sRGB to Adobe RGB). It is typically represented as a 3×3 matrix that modifies the red, green, and blue components of an image to fit a different color system.
        
    Uses of color matrix:
        - Color Primary Conversion
            - Converts RGB to YUV for video encoding.
            - Transforms sRGB to Adobe RGB for professional photography.
            - Adapts colors for different displays or devices.
        - Color Calibration
            - Adjusts white balance, gamma, and chromatic adaptation.
        - Image Processing & Computer Vision:
            - Used in cameras, displays, and software to interpret colors correctly.
            
    Common Matricies:
        - RGB -> YUV (rec 709, rec 609)}
        - sRGB to XYZ (CIE 1931)
        - Adobe RGB to sRGB
    
## Color Space
    Color space is a full encoding system that represents a gamut and contains structural information which describes that gamut and is a defined model that includes a gamut but also specifies how colors are represented numerically (e.g., RGB values) and how they should be interpreted.  Think of gamut as the set of colors a paint set can create, and color space as the instruction manual that tells you how to mix and use those colors.
    
    Color Space Components:
        - Color Primaries
        - Gamma/Transfer Function 
        - White Point
        - Matrix
    
    Relationships:
        - It is common for different color spaces to share the same primaries (e.g., Rec. 709 and sRGB both use BT.709 primaries).
        - Using the wrong primaries with a color space can cause color mismatches and inaccurate display.

    Common Color Spaces utilized in media workflows:
        - Rec. 709 (BT.709)- Standard HD Color Space
            - Usage: HDTV, Blu-ray, YouTube, broadcast television.
            - White Point: D65 (6500K)
            - Gamma Curve: ~2.4 (display gamma), 2.2 (scene-referred)
            - Color Primaries: Similar to sRGB
            - Bit Depth: Typically 8-bit or 10-bit
            - Best for: Standard HD content, YouTube, TV production.
        - Rec. 2020 (BT.2020) 
            - Usage: Ultra HD (4K/8K), HDR video, high-end broadcasting.
            - White Point: D65
            - Gamma Curve: 2.4 (SDR) / PQ or HLG (HDR)
            - Color Gamut: Much wider than Rec. 709 (includes more greens and reds).
            - Bit Depth: 10-bit or 12-bit
            - Best for: Future-proof HDR content, 4K/8K production.
        - DCI-P3
            - Digital Cinema Standard
            - Usage: Digital cinema (DCI), Apple devices, high-end displays.
            - White Point: D63 (different from Rec. 709’s D65)
            - Gamma Curve: 2.6
            - Color Gamut: Wider than Rec. 709 but smaller than Rec. 2020.
            - Bit Depth: 10-bit or more.
            - Best for: Cinema production, HDR workflows, Apple screens.
        - sRGB
            - Standard Web & Computer Display
            - Usage: Online video, general-purpose color space.
            - White Point: D65
            - Gamma Curve: ~2.2 (approximate)
            - Color Gamut: Equivalent to Rec. 709.
            - Bit Depth: 8-bit (common)
            - Best for: Web video, social media, basic color grading.
        - Adobe RGB
            - Photography & High-End Editing
            - Usage: Professional photography, video editing in Photoshop & Premiere.
            - White Point: D65
            - Gamma Curve: 2.2
            - Color Gamut: Wider than sRGB (better greens & cyans).
            - Bit Depth: 8-bit / 10-bit.
            - Best for: High-end editing, combining video with photography.
        - ACES (Academy Color Encoding System)
            - Hollywood Standard
            - Usage: High-end film production, visual effects, color grading.
            - White Point: D60
            - Gamma Curve: Scene-linear
            - Color Gamut: Extremely large (supports HDR, RAW formats)
            - Bit Depth: 16-bit (floating point).
            - Best for: Hollywood films, VFX pipelines, advanced HDR workflows.
        - HLG (Hybrid Log-Gamma)
            - HDR for Broadcast
            - Usage: HDR video for TV broadcasting (BBC, NHK, sports, live events).
            - White Point: D65
            - Gamma Curve: Log-based for HDR
            - Color Gamut: Rec. 2020
            - Bit Depth: 10-bit or more
            - Best for: HDR TV broadcasts, live sports, real-time HDR.
        - PQ (Perceptual Quantizer)
            - HDR Encoding Standard
            - Usage: HDR10, Dolby Vision, 4K HDR content.
            - White Point: D65
            - Gamma Curve: PQ (ST 2084, nonlinear)
            - Color Gamut: Rec. 2020
            - Bit Depth: 10-bit or more
            - Best for: HDR mastering, streaming platforms, Blu-ray UHD.


